class AdvancedUserRecipe1289485422(BasicNewsRecipe):
    title          = u'Guardian'
    oldest_article = 7
    max_articles_per_feed = 200
    remove_tags = [
                        dict(name='div', attrs={'class':["video-content","videos-third-column","related","terms","enclosures"]}),
                        dict(name='div', attrs={'id':["article-toolbox","subscribe-feeds",]}),
                        dict(name='ul', attrs={'class':["pagination"]}),
                        dict(name='ul', attrs={'id':["content-actions"]}),
                        dict(name='img'),
                        ]
    no_stylesheets = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                  


    feeds          = [(u'World News', u'http://feeds.guardian.co.uk/theguardian/rss'),
                          (u'UK News', u'http://feeds.guardian.co.uk/theguardian/uk/rss'),
                          (u'Health', u'http://www.guardian.co.uk/society/health/rss'),
                          (u'Music', u'http://feeds.guardian.co.uk/theguardian/music/rss'),
                          (u'Football', u'http://feeds.guardian.co.uk/theguardian/football/rss'),

]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup

	

    def parse_feeds (self): 
        feeds = BasicNewsRecipe.parse_feeds(self) 
        for feed in feeds:
           for article in feed.articles[:]:
              print 'article.title is: ', article.title
              if 'GALLERY' in article.title.upper():
                feed.articles.remove(article)
              elif 'VIDEO' in article.url.upper():
                 feed.articles.remove(article)
        return feeds	